/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.permission;

import com.suncode.dbexplorer.alias.TablesSet;
import com.suncode.dbexplorer.alias.dto.SimpleTableDto;
import com.suncode.dbexplorer.alias.permission.AccessLevel;
import java.util.Collections;
import java.util.Set;
import org.springframework.util.Assert;

public class SecuredTablesSet {
    private final TablesSet set;
    private final AccessLevel accessLevel;

    public SecuredTablesSet(TablesSet set, AccessLevel accessLevel) {
        Assert.notNull((Object)set, (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.notNull((Object)((Object)accessLevel), (String)"[Assertion failed] - this argument is required; it must not be null");
        this.set = set;
        this.accessLevel = accessLevel;
    }

    public Long getId() {
        return this.set.getId();
    }

    public String getName() {
        return this.set.getName();
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public Set<SimpleTableDto> getTables() {
        return Collections.unmodifiableSet(this.set.getTables());
    }

    public TablesSet getSet() {
        return this.set;
    }
}

