/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.dto;

import com.google.common.collect.Lists;
import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.Schema;
import com.suncode.dbexplorer.alias.dto.TableDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SchemaDto {
    private Long aliasId;
    private String name;
    private List<TableDto> tables;
    private Boolean available;

    public SchemaDto(Alias alias, Schema schema) {
        this.aliasId = alias.getId();
        this.name = schema.getName();
        this.tables = TableDto.from(alias, schema.getTables());
        this.available = true;
    }

    public static SchemaDto unavailable() {
        SchemaDto schema = new SchemaDto();
        schema.setAvailable(false);
        return schema;
    }

    public static List<SchemaDto> from(Alias alias, Set<Schema> schemas) {
        ArrayList dtos = Lists.newArrayList();
        for (Schema schema : schemas) {
            dtos.add(new SchemaDto(alias, schema));
        }
        return dtos;
    }

    public Long getAliasId() {
        return this.aliasId;
    }

    public String getName() {
        return this.name;
    }

    public List<TableDto> getTables() {
        return this.tables;
    }

    public Boolean getAvailable() {
        return this.available;
    }

    public void setAliasId(Long aliasId) {
        this.aliasId = aliasId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTables(List<TableDto> tables) {
        this.tables = tables;
    }

    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public SchemaDto() {
    }
}

