/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.Column;
import com.suncode.dbexplorer.alias.Table;
import com.suncode.dbexplorer.database.schema.ColumnSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ColumnDto {
    private Long aliasId;
    private String schemaName;
    private String tableName;
    private String name;
    private String displayName;
    private String type;
    private Integer length;
    private boolean nullable;
    private boolean autoIncrement;
    private boolean unique;

    public ColumnDto() {
    }

    public ColumnDto(Alias alias, Table table, Column column) {
        this.schemaName = table.getSchema();
        this.tableName = table.getName();
        this.aliasId = alias.getId();
        this.name = column.getName();
        this.displayName = column.getDisplayName();
        ColumnSchema schema = column.getColumnSchema();
        this.type = schema.getType().getName();
        this.length = schema.getType().getNativeType().getLength();
        this.nullable = schema.isNullable();
        this.autoIncrement = schema.isAutoIncrement();
        this.unique = schema.isUnique();
    }

    public static List<ColumnDto> from(Alias alias, Table table, Collection<Column> columns) {
        ArrayList<ColumnDto> dtos = new ArrayList<ColumnDto>();
        for (Column column : columns) {
            dtos.add(new ColumnDto(alias, table, column));
        }
        return dtos;
    }

    public Long getAliasId() {
        return this.aliasId;
    }

    public void setAliasId(Long aliasId) {
        this.aliasId = aliasId;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }
}

