package com.suncode.dbexplorer.util.web.rest;

import com.suncode.dbexplorer.util.authorization.NotFullRightsException;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import com.suncode.pwfl.web.support.ajax.RestResult;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@Slf4j
@RequestMapping( value = "/api", produces = RestController.JSON_TYPE )
public abstract class RestController
{
	private static final Logger logger = LoggerFactory.getLogger(RestController.class);

	public static final String JSON_TYPE = "application/json";

	@ExceptionHandler(Exception.class)
	public ResponseEntity<RestApiError> handleException(Exception e)
	{
		logger.error("REST API error occurred", e);
		RestApiError restApiError =
				new RestApiError(HttpStatus.INTERNAL_SERVER_ERROR)
					.setMessage("Internal server error occurred");
        return createResponseEntity( restApiError );
    }

    @ExceptionHandler( RestApiException.class )
    public ResponseEntity<RestApiError> handleRestApiException( RestApiException e )
    {
        logger.error( "REST API error occurred", e );
        return this.createResponseEntity( e.getError() );
    }

    protected ResponseEntity<RestApiError> createResponseEntity( RestApiError restApiError )
    {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType( MediaType.APPLICATION_JSON );

        HttpStatus responseStatus = HttpStatus.valueOf( restApiError.getHttpStatus() );
        return new ResponseEntity<>( restApiError, headers, responseStatus );
    }

    @ExceptionHandler( NotFullRightsException.class )
    @ResponseStatus( HttpStatus.UNAUTHORIZED )
    @ResponseBody
    public RestResult handleUnauthorizedRequests( NotFullRightsException e )

    {
        Translator translator = Translators.get( RestController.class );
        log.info( translator.getMessage( "dbex.no.rights" ) );
        return new RestResult( false, translator.getMessage( "dbex.no.rights" ) );
    }
}
