package com.suncode.dbexplorer.util.web.rest;

import org.springframework.http.HttpStatus;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class RestApiError {

	private final int httpStatus;
	private String message;
	private String userMessage;

	@JsonCreator
	public RestApiError(@JsonProperty("httpStatus") int httpStatus) {
		this.httpStatus = httpStatus;
	}

	public RestApiError(HttpStatus httpStatus) {
		this.httpStatus = httpStatus.value();
	}

	public int getHttpStatus() {
		return httpStatus;
	}

	public String getMessage() {
		return message;
	}

	public RestApiError setMessage(String message) {
		this.message = message;
		return this;
	}

	public String getUserMessage() {
		return userMessage;
	}

	public RestApiError setUserMessage(String userMessage) {
		this.userMessage = userMessage;
		return this;
	}
}
