package com.suncode.dbexplorer.util.persistence;

import lombok.RequiredArgsConstructor;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;

@RequiredArgsConstructor
public class PrefixTableNamingStrategy implements PhysicalNamingStrategy {
	private final String prefix;
	private final PhysicalNamingStrategy delegate;

	@Override
	public Identifier toPhysicalTableName(Identifier name, JdbcEnvironment jdbcEnvironment) {
		var tableName = delegate.toPhysicalTableName(name, jdbcEnvironment);
		return new Identifier(
				prefix + tableName.getText(),
				tableName.isQuoted()
		);
	}

	@Override
	public Identifier toPhysicalCatalogName(Identifier name, JdbcEnvironment jdbcEnvironment) {
		return delegate.toPhysicalCatalogName(name, jdbcEnvironment);
	}

	@Override
	public Identifier toPhysicalSchemaName(Identifier name, JdbcEnvironment jdbcEnvironment) {
		return delegate.toPhysicalSchemaName(name, jdbcEnvironment);
	}

	@Override
	public Identifier toPhysicalSequenceName(Identifier name, JdbcEnvironment jdbcEnvironment) {
		return delegate.toPhysicalSequenceName(name, jdbcEnvironment);
	}

	@Override
	public Identifier toPhysicalColumnName(Identifier name, JdbcEnvironment jdbcEnvironment) {
		return delegate.toPhysicalColumnName(name, jdbcEnvironment);
	}
}
