package com.suncode.dbexplorer.util.convert;

import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.core.convert.converter.Converter;

import java.util.Date;

public class StringToDateConverter implements Converter<String, Date> {

	private final DateTimeFormatter[] FORMATS = new DateTimeFormatter[] {
			// TODO: znane formaty
			ISODateTimeFormat.dateOptionalTimeParser()
	};

	@Override
	public Date convert(String source)
    {
        if ( StringUtils.isBlank( source ) )
        {
            return null;
        }

		// timestamp
		try {
			long date = Long.parseLong(source.trim());
			return new Date(date);
		}
		catch (NumberFormatException e) {
			// not a timestamp
		}

		// inne znane formaty
		for (DateTimeFormatter formatter : FORMATS) {
			try {
				DateTime parsed = formatter.parseDateTime(source);
				return parsed.toDate();
			}
			catch (IllegalArgumentException e) {
				// try next
			}
		}
		throw new IllegalArgumentException();
	}
}
