package com.suncode.dbexplorer.util.authorization;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.suncode.dbexplorer.alias.permission.AccessLevel;
import com.suncode.dbexplorer.alias.permission.PermissionsService;
import com.suncode.pwfl.administration.user.UserContext;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RequiredArgsConstructor( onConstructor_ = { @Autowired } )
public class AuthorizationHelper
{
    private final PermissionsService permissionsService;

    @SneakyThrows
    public void assertFullAdministrationRights( Runnable callbackIfHasNoRights )
    {
        String name = UserContext.current().getUser().getUserName();
        int right = Authorization.checkRight( RightTreeBuilder.builder().system().admin().build(), name, false, false );
        if ( right != Authorization.nFULL )
        {
            callbackIfHasNoRights.run();
            throw new NotFullRightsException();
        }
    }

    @SneakyThrows
    public void hasAccessToTable( String username, String tableName, AccessLevel accessLevel )
    {
        boolean hasPermissionToTable = permissionsService.hasPermissionToTable( username, tableName, accessLevel );

        if ( !hasPermissionToTable )
        {
            throw new NotFullRightsException();
        }
    }
}
