package com.suncode.dbexplorer.database.type.support;

import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.dbexplorer.database.type.BasicDataType;

public class TypeConventer
{

    /**
     * Konwertuje podany typ danych na konkretny odpowiednik w podanej bazie danych
     * 
     * @param type Typ danych
     * @param database Typ bazy danych
     * @return Tekstowy odpowiednik typu danych dla konkretnej bazy danych
     */
    public static String convert( BasicDataType type, DatabaseType database )
    {
        return getType( type, database );
    }

    private static String getType( BasicDataType type, DatabaseType database )
    {
        if ( type == BasicDataType.INTEGER )
        {
            return convertInteger();
        }
        else if ( type == BasicDataType.STRING )
        {
            return convertString( database );
        }
        else if ( type == BasicDataType.BOOLEAN )
        {
            return convertBoolean( database );
        }
        else if ( type == BasicDataType.BINARY )
        {
            return convertBinary( database );
        }
        else if ( type == BasicDataType.DATE )
        {
            return convertDate();
        }
        else if ( type == BasicDataType.DATETIME )
        {
            return convertDateTime( database );
        }
        else if ( type == BasicDataType.FLOAT )
        {
            return convertFloat( database );
        }
        else if ( type == BasicDataType.TIME )
        {
            return convertTime( database );
        }
        throw new RuntimeException( "Cannot convert BasicDataType for " + type );
    }

    private static String convertInteger()
    {
        return "INTEGER";
    }

    private static String convertString( DatabaseType database )
    {
        if ( database == DatabaseType.ORACLE )
        {
            return "VARCHAR2(4000)";
        }
        return "VARCHAR(4000)";
    }

    private static String convertBoolean( DatabaseType database )
    {
        if ( database == DatabaseType.SQLSERVER )
        {
            return "BIT";
        }
        else if ( database == DatabaseType.ORACLE )
        {
            return "NUMBER(1)";
        }
        else
        {
            return "BOOLEAN";
        }
    }

    private static String convertBinary( DatabaseType database )
    {
        if ( database == DatabaseType.POSTGRES )
        {
            return "BYTEA";
        }
        else if ( database == DatabaseType.ORACLE )
        {
            return "BINARY_DOUBLE";
        }
        else
        {
            return "BINARY(7500)";
        }
    }

    private static String convertDate()
    {
        return "DATE";
    }

    private static String convertDateTime( DatabaseType database )
    {
        if ( database == DatabaseType.SQLSERVER )
        {
            return "DATETIME";
        }
        return "TIMESTAMP";
    }

    private static String convertFloat( DatabaseType database )
    {
        if ( database == DatabaseType.POSTGRES )
        {
            return "DOUBLE PRECISION";
        }
        else if ( database == DatabaseType.ORACLE )
        {
            return "FLOAT(15)";
        }
        return "FLOAT";
    }

    private static String convertTime( DatabaseType database )
    {
        if ( database == DatabaseType.ORACLE )
        {
            throw new RuntimeException( "Oracle databases do not support TIME type.");
        }
        return "TIME";
    }
}