package com.suncode.dbexplorer.database.schema;

import com.google.common.collect.Iterables;
import org.springframework.util.Assert;

import java.util.Set;

/**
 * @author Cezary Kozar 23 wrz 2015
 */
public class PrimaryKey
{

    private String name;

    private Set<String> columns;

    private boolean createdFromIndexes;

    public PrimaryKey( String name, Set<String> columns )
    {
        this.name = name;
        this.columns = columns;
    }

    public PrimaryKey( String name, Set<String> columns, boolean createdFromIndexes )
    {
        this.name = name;
        this.columns = columns;
        this.createdFromIndexes = createdFromIndexes;
    }

    public String getName()
    {
        return name;
    }

    public boolean isCreatedFromIndexes()
    {
        return createdFromIndexes;
    }

    public boolean isComposite()
    {
        return columns.size() > 1;
    }

    public String[] getColumns()
    {
        return Iterables.toArray( columns, String.class );
    }

    public String getColumn()
    {
        Assert.state( !isComposite(), "This primary key contains more than 1 column" );
        return Iterables.getOnlyElement( columns );
    }
}
