package com.suncode.dbexplorer.database.query;

import java.util.List;

import com.suncode.dbexplorer.database.Record;

public interface SelectQuery
{
	SelectQuery from(String table);
	
	SelectQuery from(String schema, String table);

	SelectQuery where(Condition condition);
	
	SelectQuery where(Condition... conditions);

	SelectQuery addOrder(Order order);
	
	SelectQuery addOrder(Order... order);
	
	SelectQuery includeBinary();

	List<Record> list();

	Page<Record> page(Pagination pagination);

	Record uniqueRecord();

	long count();
}
