package com.suncode.dbexplorer.database.query;

public class Order {

	public enum OrderType {
		ASC,
		DESC
	}

	private final String column;

	private final OrderType orderType;

	public Order(String column) {
		this(column, OrderType.ASC);
	}

	public Order(String column, OrderType orderType) {
		this.column = column;
		this.orderType = orderType;
	}

	public String getColumn() {
		return column;
	}

	public OrderType getOrderType() {
		return orderType;
	}

	public static Order ASC(String column) {
		return new Order(column, OrderType.ASC);
	}

	public static Order DESC(String column) {
		return new Order(column, OrderType.DESC);
	}

}
