package com.suncode.dbexplorer.database.query;

import org.springframework.util.Assert;

import com.suncode.dbexplorer.database.type.DataType;

class OperatorCondition implements Condition {

	public enum Operator {
		EQ("="),
		LE("<="),
		GE(">="),
		LT("<"),
		GT(">");

		private String op;

		private Operator(String op) {
			this.op = op;
		}

		private String getOp() {
			return op;
		}
	}

	private final String column;
	private final Object value;
	private final Operator operator;

	public OperatorCondition(String column, Operator operator, Object value) {
		Assert.notNull( value, "[Assertion failed] - this argument is required; it must not be null" );

		this.column = column;
		this.operator = operator;
		this.value = value;
	}

	@Override
	public String toSql(QueryContext queryContext) {
		String alias = queryContext.getColumnAlias(column);
		StringBuilder sql = new StringBuilder()
			.append(alias)
			.append(operator.getOp())
			.append("?");

		return sql.toString();
	}

	@Override
	public QueryParameter[] getParameters(QueryContext queryContext) {
		DataType type = queryContext.getTypeOf(column);
		return new QueryParameter[] { new QueryParameter(value, type) };
	}
}
