package com.suncode.dbexplorer.database.query;

import org.springframework.util.Assert;

/**
 * Warunek negacji
 * 
 * @author Cezary Kozar 17 sty 2016
 */
public class NotCondition
    implements Condition
{
    private final Condition condition;

    public NotCondition( Condition condition )
    {
        Assert.notNull( condition, "[Assertion failed] - this argument is required; it must not be null" );
        this.condition = condition;
    }

    @Override
    public String toSql( QueryContext queryContext )
    {
        return "not (" + condition.toSql( queryContext ) + ")";
    }

    @Override
    public QueryParameter[] getParameters( QueryContext queryContext )
    {
        return condition.getParameters( queryContext );
    }
}
