package com.suncode.dbexplorer.database.query;

import com.suncode.dbexplorer.database.type.BasicDataType;

public interface CreateQuery
{
    /**
     * Ustawia nazwę tabeli
     */
    CreateQuery table( String table );

    /**
     * Ustawia nazwę tabeli
     */
    CreateQuery table( String schema, String table );

    /**
     * Dodaje nową kolumnę do tabeli
     */
    CreateQuery column( String name, BasicDataType dataType );

    /**
     * Dodaje nową kolumnę do tabeli
     */
    CreateQuery column( String name, BasicDataType dataType, boolean nullable );

    /**
     * Dodaje nową kolumnę do tabeli
     */
    CreateQuery column( String name, BasicDataType dataType, boolean nullable, boolean autoincrement );

    /**
     * Ustawia wybraną kolumnę jako primary key. W przypadku wielokrotnego użycia ustawia wszystkie
     * wybrane kolumny jako primary key.
     */
    CreateQuery setAsPrimary();

    /**
     * Ustawia wybraną kolumnę jako foreign key
     * 
     * @param table Nazwa tablicy, do której odnosić się będzie klucz.
     * @param columnName Nazwa kolumny, na którą wskazywać będzie klucz.
     */
    CreateQuery setAsForeign( String table, String columnName );

    int execute();
}
