package com.suncode.dbexplorer.database.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

import com.google.common.collect.Iterables;

public class AndOrCondition implements Condition {

	public enum Type {
		AND,
		OR;
	}

	private final Type type;
	private final Condition[] conditions;

	public AndOrCondition(Type type, Condition... conditions) {
		Assert.notNull( type, "[Assertion failed] - this argument is required; it must not be null" );
		Assert.notNull( conditions, "[Assertion failed] - this argument is required; it must not be null" );

		this.type = type;
		this.conditions = conditions;
	}

	@Override
	public String toSql(QueryContext queryContext) {
		List<String> conditionsSql = new ArrayList<String>();
		for (Condition condition : conditions) {
			conditionsSql.add(condition.toSql(queryContext));
		}

		StringBuilder sql = new StringBuilder()
			.append("(")
			.append(StringUtils.join(conditionsSql, " " + type.name() + " "))
			.append(")");

		return sql.toString();
	}

	@Override
	public QueryParameter[] getParameters(QueryContext queryContext) {
		List<QueryParameter> parameters = new ArrayList<QueryParameter>();
		for (Condition condition : conditions) {
			QueryParameter[] params = condition.getParameters(queryContext);
			Collections.addAll(parameters, params);
		}
		return Iterables.toArray(parameters, QueryParameter.class);
	}
}
