package com.suncode.dbexplorer.database.internal.type.hibernate;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;

import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Deskryptor typu {@linkplain java.sql.Types#OTHER}
 * 
 * @author Cezary Kozar 15 sty 2016
 */
@SuppressWarnings( "serial" )
public class OtherTypeDescriptor
    implements SqlTypeDescriptor
{
    private final Logger logger = LoggerFactory.getLogger( getClass() );

    public static final OtherTypeDescriptor INSTANCE = new OtherTypeDescriptor();

    protected OtherTypeDescriptor()
    {
    }

    @Override
    public int getSqlType()
    {
        return Types.OTHER;
    }

    @Override
    public boolean canBeRemapped()
    {
        return true;
    }

    @Override
    public <X> ValueBinder<X> getBinder( final JavaTypeDescriptor<X> javaTypeDescriptor )
    {
        throw new IllegalStateException( "Binding query parameters with UnknownType is not supported" );
    }

    @Override
    public <X> ValueExtractor<X> getExtractor( final JavaTypeDescriptor<X> javaTypeDescriptor )
    {
        return new BasicExtractor<X>( javaTypeDescriptor, this )
        {
            @Override
            protected X doExtract( ResultSet rs, String name, WrapperOptions options )
                throws SQLException
            {
                Object value = null;
                try
                {
                    value = rs.getObject( name );
                }
                catch ( SQLException e )
                {
                    logger.debug( "Could not read column [{}] value as Object from ResultSet", name );
                    try
                    {
                        value = rs.getString( name );
                    }
                    catch ( SQLException e1 )
                    {
                        logger.warn( "Could not read column [{}] value as Object or String from ResultSet", name );
                        return null;
                    }
                }
                return javaTypeDescriptor.wrap( value, options );
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                // migration: implement
                return null;
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                // migration: implement
                return null;
            }
        };
    }
}
