package com.suncode.dbexplorer.database.internal.type.hibernate;

import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.AbstractStandardBasicType;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Types;

/**
 * Typ obsługujący kolumny o typie SQL {@linkplain Types#OTHER}.
 * <p>
 * Przedstawia dowolny obiekt odczytany z bazy danych w postaci tekstu.
 * <p>
 * <b>READ ONLY
 * 
 * @author Cezary Kozar 15 sty 2016
 */
@SuppressWarnings( "serial" )
public class OtherType
    extends AbstractStandardBasicType<String>
{
    public static final OtherType INSTANCE = new OtherType();

    protected OtherType()
    {
        super( OtherTypeDescriptor.INSTANCE, AnyStringTypeDescriptor.INSTANCE );
    }

    @Override
    public String getName()
    {
        return "other";
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        throw new IllegalStateException( "Using type OTHER in query parameter is not allowed" );
    }
}