package com.suncode.dbexplorer.database.internal.type.hibernate;

import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

/**
 * Deskryptor zamieniający dowolny obiekt w jego reprezentację {@link Object#toString()}
 * 
 * @author Cezary Kozar 15 sty 2016
 */
@SuppressWarnings( "serial" )
public class AnyStringTypeDescriptor
    extends AbstractTypeDescriptor<String>
{
    public static final AnyStringTypeDescriptor INSTANCE = new AnyStringTypeDescriptor();

    protected AnyStringTypeDescriptor()
    {
        super( String.class );
    }

    @Override
    public String toString( String value )
    {
        return value;
    }

    @Override
    public String fromString( String string )
    {
        return string;
    }

    @Override
    public <X> X unwrap( String value, Class<X> type, WrapperOptions options )
    {
        // unwrap wykorzystywany jest podczas używania tego typu w parametrach - my na to nie
        // pozwalamy
        throw new IllegalStateException( "Unwrapping not supported" );
    }

    @Override
    public <X> String wrap( X value, WrapperOptions options )
    {
        if ( value == null )
        {
            return null;
        }
        return value.toString();
    }

}
