package com.suncode.dbexplorer.database.internal.type;

import org.hibernate.SQLQuery;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.suncode.dbexplorer.database.type.DataType;

public abstract class HibernateDataTypeHandler
        implements DataTypeHandler
{
    private static Logger logger = LoggerFactory.getLogger( HibernateDataTypeHandler.class );

    public HibernateDataTypeHandler()
    {
    }

    protected abstract Type resolveHibernateType( DataType dataType );

    @Override
    public void bindParameter( DataType dataType, String parameterName, Object rawValue, SQLQuery query )
    {
        Object value = rawValue;
        Type hibernateType = resolveHibernateType( dataType );
        if ( value != null && needConversion( value, hibernateType ) )
        {
            try
            {
                value = convert( rawValue, hibernateType.getReturnedClass(), dataType );
            }
            catch ( RuntimeException e )
            {
                logger.error( "Could not convert value [{}] to {}", rawValue, hibernateType.getReturnedClass() );
                throw e;
            }
        }

        query.setParameter( parameterName, value, hibernateType );
    }

    @Override
    public void setScalar( DataType dataType, String columnAlias, SQLQuery query )
    {
        query.addScalar( columnAlias, resolveHibernateType( dataType ) );
    }

    protected abstract Object convert( Object value, Class<?> targetClass, DataType dataType );

    private boolean needConversion( Object value, Type type )
    {
        return !type.getReturnedClass().isInstance( value );
    }
}