package com.suncode.dbexplorer.database.internal.type;

import org.hibernate.SQLQuery;

import com.suncode.dbexplorer.database.type.BinaryDataType;
import com.suncode.dbexplorer.database.type.DataType;
import com.suncode.dbexplorer.database.type.NativeType;

/**
 * Obsługa typu binarnego {@linkplain BinaryDataType}
 * 
 * @author Cezary Kozar 14 sty 2016
 */
public class BinaryDataTypeHandler
    implements DataTypeHandler
{
    @Override
    public DataType create( NativeType nativeType )
    {
        return new BinaryDataType( nativeType );
    }

    @Override
    public void bindParameter( DataType dataType, String parameterName, Object value, SQLQuery query )
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setScalar( DataType dataType, String columnAlias, SQLQuery query )
    {
        // TODO: musimy miec wplyw na to - nie chcemy odczytywac danych binarnych chyba ze sami to
        // wymusimy
    }
}
