package com.suncode.dbexplorer.database.internal.query.support;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.suncode.dbexplorer.database.internal.query.CreateQueryImpl.Column;

import lombok.AllArgsConstructor;

@AllArgsConstructor
public abstract class BuildSqlQuery
{
    protected String tableName;

    protected List<Column> columns;

    protected Set<Integer> primaryKeyIndexes;

    protected Map<String, String[]> foreignKeys;

    public abstract String buildSql();

    protected String getSqlForForeignKeys()
    {
        StringBuilder sql = new StringBuilder();
        if ( !this.foreignKeys.isEmpty() )
        {
            for ( String[] foreignkeyData : foreignKeys.values() )
            {
                String[] foreignKey = foreignkeyData;
                sql.append( ", CONSTRAINT fk_" + foreignKey[1] );
                sql.append( " FOREIGN KEY (" + foreignKey[0] + ")" );
                sql.append( " REFERENCES " + foreignKey[1] + "(" + foreignKey[2] + ") " );
            }
        }
        return sql.toString();
    }

    protected String getSqlForPrimaryKeys()
    {
        StringBuilder sql = new StringBuilder();
        if ( !this.primaryKeyIndexes.isEmpty() )
        {
            sql.append( ", CONSTRAINT " + this.tableName + "_pk PRIMARY KEY(" );
            for ( Integer primaryId : this.primaryKeyIndexes )
            {
                sql.append( this.columns.get( primaryId ).getName() + ", " );
            }

            sql.delete( sql.length() - 2, sql.length() );
            sql.append( ") " );
        }
        return sql.toString();
    }
}