package com.suncode.dbexplorer.database.internal.query.support;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.suncode.dbexplorer.database.internal.query.CreateQueryImpl.Column;

public class BuildCreateQueryPostgres
    extends BuildSqlQuery
{

    public BuildCreateQueryPostgres( String tableName, List<Column> columns, Set<Integer> primaryKeyIndexes,
                               Map<String, String[]> foreignKeys )
    {
        super( tableName, columns, primaryKeyIndexes, foreignKeys );
    }

    @Override
    public String buildSql()
    {
        StringBuilder sql = new StringBuilder();
        for ( Column column : columns )
        {
            sql.append( column.getName() + " " );
            sql.append( ( column.isAutoincrement() ? "SERIAL" : column.getType() ) + " " );
            sql.append( ( column.isNullable() ? " " : "NOT NULL " ) );
            sql.append( ( this.foreignKeys.containsKey( column.getName() ) ? getSqlForForeignKeys( column )
                            : ", " ) );
        }
        sql.delete( sql.length() - 2, sql.length() );
        sql.append( getSqlForPrimaryKeys() );
        sql.append( ");" );
        return sql.toString();
    }

    @Override
    protected String getSqlForPrimaryKeys()
    {
        StringBuilder sql = new StringBuilder();
        if ( !this.primaryKeyIndexes.isEmpty() )
        {
            sql.append( ", PRIMARY KEY (" );
            for ( Integer primaryId : this.primaryKeyIndexes )
            {
                sql.append( this.columns.get( primaryId ).getName() + ", " );
            }

            sql.delete( sql.length() - 2, sql.length() );
            sql.append( ")" );
        }
        return sql.toString();
    }

    protected String getSqlForForeignKeys( Column column )
    {
        String[] foreignData = this.foreignKeys.get( column.getName() );
        String sql = "REFERENCES " + foreignData[1] + " (" + foreignData[2] + "), ";
        return sql;
    }
}