package com.suncode.dbexplorer.database.internal.query.support;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.suncode.dbexplorer.database.internal.query.CreateQueryImpl.Column;

public class BuildCreateQueryOracle
    extends BuildSqlQuery
{

    public BuildCreateQueryOracle( String tableName, List<Column> columns, Set<Integer> primaryKeyIndexes,
                             Map<String, String[]> foreignKeys )
    {
        super( tableName, columns, primaryKeyIndexes, foreignKeys );
    }

    @Override
    public String buildSql()
    {
        StringBuilder sql = new StringBuilder();
        for ( Column column : columns )
        {
            sql.append( column.getName() + " " + column.getType() + " " );
            sql.append( ( column.isNullable() ? ", " : "NOT NULL, " ) );
            
            if(column.isAutoincrement()){
                throw new RuntimeException( "Cannot apply autoincrement in Oracle databases.");
            }
        }
        sql.delete( sql.length() - 2, sql.length() );
        sql.append( getSqlForPrimaryKeys() );
        sql.append( getSqlForForeignKeys() );
        sql.append( ")" );
        return sql.toString();
    }
}