package com.suncode.dbexplorer.database.internal.query;

import com.suncode.dbexplorer.database.internal.DatabaseImplementor;
import com.suncode.dbexplorer.database.query.QueryContext;
import com.suncode.dbexplorer.database.schema.TableSchema;
import com.suncode.dbexplorer.database.type.DataType;

// TODO: może inner class w AbstractQuery
public class QueryContextImpl implements QueryContext {

	private final TableSchema rootTable;

	private final DatabaseImplementor implementor;

	public QueryContextImpl(TableSchema rootTable, DatabaseImplementor implementor) {
		this.rootTable = rootTable;
		this.implementor = implementor;
	}

	@Override
	public String getColumnAlias(String column) {
		// TODO: przewiduję aliasy - ale jak nie będzie to trzeba zmienic nazwę metody
		return implementor.escapeColumnName(column);
	}

	@Override
	public DataType getTypeOf(String column) {
		return rootTable.getColumn(column).getType();
	}

	@Override
	public TableSchema getRootTable() {
		return rootTable;
	}
}
