package com.suncode.dbexplorer.database.internal.query;

import org.hibernate.SQLQuery;
import org.springframework.util.Assert;

import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.internal.DatabaseImplementor;
import com.suncode.dbexplorer.database.query.DropQuery;

public class DropQueryImpl
    extends AbstractQuery
    implements DropQuery
{

    public DropQueryImpl( DatabaseSession session, DatabaseImplementor implementor )
    {
        super( session, implementor );
    }

    @Override
    public DropQuery table( String table )
    {
        Assert.hasText( table, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank" );
        TablePathInfo pathInfo = getPathInfo( table );
        return table( pathInfo.getSchema(), pathInfo.getName() );
    }

    @Override
    public DropQuery table( String schema, String table )
    {
        Assert.hasText( schema, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank" );
        Assert.hasText( table, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank" );
        this.rootTable = session.getDatabase().getSchema( schema ).getTable( table );
        return this;
    }

    @Override
    public int execute()
    {
        StringBuilder sql = new StringBuilder();
        sql.append( "DROP TABLE " + this.rootTable.getFullName() );
        SQLQuery sqlQuery = session.hibernateSession().createSQLQuery( sql.toString() );
        return sqlQuery.executeUpdate();
    }
}