package com.suncode.dbexplorer.database.internal.postgres;

import java.util.List;

import org.hibernate.type.StandardBasicTypes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.dbexplorer.database.internal.support.AbstractDatabaseImplementor;

@Component
public class PostgresDatabase
    extends AbstractDatabaseImplementor
{
    public @Autowired PostgresDatabase( PostgresSchemaLoader schemaLoader, PostgresConnectionUrlResolver urlResolver,
                                        PostgresDataTypeRegistry typeRegistry )
    {
        super( DatabaseType.POSTGRES, schemaLoader, urlResolver, typeRegistry );
    }

    @Override
    protected String getDriverClassName()
    {
        return "org.postgresql.Driver";
    }

    @Override
    public String getCurrentSchemaName( DatabaseSession session )
    {
        return (String) session.hibernateSession()
            .createSQLQuery( "select current_schema() as schema" )
            .addScalar( "schema", StandardBasicTypes.STRING )
            .uniqueResult();
    }

    @Override
    @SuppressWarnings( "unchecked" )
    public List<String> getSchemasNames( DatabaseSession session )
    {
        return (List<String>) session.hibernateSession()
            .createSQLQuery( "select schema_name as schema from information_schema.schemata where schema_name NOT LIKE 'pg_%' AND schema_name != 'information_schema'" )
            .addScalar( "schema", StandardBasicTypes.STRING )
            .list();
    }
}
