package com.suncode.dbexplorer.database.internal.postgres;

import org.springframework.stereotype.Component;

import com.suncode.dbexplorer.database.internal.postgres.type.PostgresBooleanTypeHandler;
import com.suncode.dbexplorer.database.internal.type.DefaultDataTypeRegistry;
import com.suncode.dbexplorer.database.type.BooleanDataType;
import com.suncode.dbexplorer.database.type.UnknownDataType;

@Component
public class PostgresDataTypeRegistry
    extends DefaultDataTypeRegistry
{
    public PostgresDataTypeRegistry()
    {
        super();

        // bit -> Boolean
        registerTypeHandler( BooleanDataType.class, new PostgresBooleanTypeHandler() );

        // Brak wsparcia dla "money" -> błednie działa na poziomie JDBC
        // money -> UNKNOWN
        mapNativeType( "money", UnknownDataType.class );
    }
}
