package com.suncode.dbexplorer.database.internal.db2as400;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.internal.schema.jdbc.ColumnData;
import com.suncode.dbexplorer.database.internal.schema.jdbc.JdbcSchemaLoader;
import com.suncode.dbexplorer.database.internal.support.ResultSetMapper;
import com.suncode.dbexplorer.database.schema.ColumnSchema;
import com.suncode.dbexplorer.database.schema.Sequence;
import com.suncode.dbexplorer.database.type.DataType;
import com.suncode.dbexplorer.database.type.NativeType;

@Component
public class DB2AS400SchemaLoader
    extends JdbcSchemaLoader
{
    DB2AS400DataTypeRegistry dataTypeRegistry;

    public @Autowired DB2AS400SchemaLoader( DB2AS400DataTypeRegistry dataTypeRegistry )
    {
        super( dataTypeRegistry );
        this.dataTypeRegistry = dataTypeRegistry;
    }

    @Override
    @SuppressWarnings( "unchecked" )
    protected List<Sequence> readSequences( DatabaseSession session, String schemaName )
    {
        List<Map<String, Object>> results = session.hibernateSession()
            .createSQLQuery( "select sequence_name as seqname from QSYS2.SYSSEQUENCES" )
            .addScalar( "seqname", StandardBasicTypes.STRING )
            .setResultTransformer( Transformers.ALIAS_TO_ENTITY_MAP )
            .list();

        List<Sequence> sequences = Lists.newArrayList();
        for ( Map<String, Object> row : results )
        {
            String sequenceName = (String) row.get( "seqname" );
            sequences.add( new Sequence( sequenceName ) );
        }
        return sequences;
    }
}
