package com.suncode.dbexplorer.database.internal.db2;

import java.util.Arrays;
import java.util.List;

import org.hibernate.type.StandardBasicTypes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.dbexplorer.database.internal.support.AbstractDatabaseImplementor;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Component
public class DB2Database
    extends AbstractDatabaseImplementor
{
    public @Autowired DB2Database( DB2SchemaLoader schemaLoader, DB2ConnectionUrlResolver urlResolver,
                                      DB2DataTypeRegistry typeRegistry )
    {
        super( DatabaseType.DB2, schemaLoader, urlResolver, typeRegistry );
    }

    @Override
    protected String getDriverClassName()
    {
        return "com.ibm.db2.jcc.DB2Driver";
    }

    @Override
    public String getCurrentSchemaName( DatabaseSession session )
    {
        return (String) session.hibernateSession()
            .createSQLQuery( "select current_schema as schema from sysibm.sysdummy1" )
            .addScalar( "schema", StandardBasicTypes.STRING )
            .uniqueResult();
    }

    @Override
    @SuppressWarnings( "unchecked" )
    public List<String> getSchemasNames( DatabaseSession session )
    {
        return (List<String>) session.hibernateSession()
                        .createSQLQuery( "select schemaname AS schema from syscat.schemata WHERE DEFINERTYPE = 'U' AND schemaname not in ('NULLID ','SQLJ', 'SYSTOOLS' )" )
                        .addScalar( "schema", StandardBasicTypes.STRING )
                        .list();
    }
}
