package com.suncode.dbexplorer.database;

import java.sql.Connection;

import org.hibernate.StatelessSession;

import com.suncode.dbexplorer.alias.data.CreateTable;
import com.suncode.dbexplorer.database.query.CreateQuery;
import com.suncode.dbexplorer.database.query.DeleteQuery;
import com.suncode.dbexplorer.database.query.DropQuery;
import com.suncode.dbexplorer.database.query.InsertQuery;
import com.suncode.dbexplorer.database.query.SelectQuery;
import com.suncode.dbexplorer.database.query.UpdateQuery;
import com.suncode.dbexplorer.database.schema.TableSchema;

/**
 * @author Cezary Kozar 30 lip 2015
 */
public interface DatabaseSession
{
    Database getDatabase();

    Connection getConnection();

    StatelessSession hibernateSession();

    void rollback();

    void commit();

    boolean isActive();

    // Pogodzic się z tym że mamy hibernate'a pod spodem?
    // JAK???
    // AAAAA
    // NIEEEE

    // Record
    Record createRecord( String table );

    Record createRecord( String schema, String table );

    Record get( String table, RecordId id );

    Record get( String schema, String table, RecordId id );

    void insert( Record record );

    boolean update( Record record );

    void delete( Record record );

    // Table
    void createTable( CreateTable table );

    void drop( String table );

    void drop( String schema, String table );

    void drop( TableSchema table );

    // Query
    SelectQuery select();

    InsertQuery insert();

    UpdateQuery update();

    DeleteQuery delete();

    CreateQuery create();

    DropQuery drop();
}
