package com.suncode.dbexplorer.database;

import com.suncode.dbexplorer.database.schema.DatabaseSchema;

import java.util.List;

/**
 * @author Cezary Kozar 30 lip 2015
 */
public interface Database
{
    boolean handles( DatabaseType type );

    String getCatalog();

    String getSchemaName();

    String getDefaultSchemaName();

    List<String> getSchemasNames();

    DatabaseSchema getSchema();

    DatabaseSchema getSchema( String name );

    List<DatabaseSchema> getSchemas();

    /**
     * @deprecated {@link Database#updateSchema()}
     */
    @Deprecated
    void schemaUpdated();

    void updateSchema();

    DatabaseSession openSession();

    <T> T withinSession( SessionUnit<T> unit );
}
