package com.suncode.dbexplorer.database;

import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Transient;

import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Embeddable
@NoArgsConstructor
public class ConnectionStringDomain
{

    @Getter
    @Column( name = "db_type" )
    private DatabaseType type;

    @Getter
    @Column( name = "db_catalog" )
    private String catalog;

    @Getter
    @Setter
    @Column( name = "db_schema" )
    private String schema;

    @Getter
    @Column( name = "db_host" )
    private String host;

    @Getter
    @Column( name = "db_port" )
    private Integer port;

    @Getter
    @Column( name = "db_user" )
    private String user;

    @Getter
    @Column( name = "db_password" )
    private String password;

    @Getter
    @Setter
    @Column( name = "jdbc_url" )
    private String jdbcUrl;

    @Builder
    public ConnectionStringDomain( DatabaseType type, String catalog, String schema, String host, Integer port, String user,
                             String password, String jdbcUrl )
    {
        if ( !notEmpty( jdbcUrl ) )
        {
            Assert.notNull( type, "[Assertion failed] - this argument is required; it must not be null" );
            Assert.hasText( host, "Database host cannot be empty if JDBC URL is not specified" );
        }

        this.type = type;
        this.catalog = catalog;
        this.schema = schema;
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.jdbcUrl = jdbcUrl;
    }

    private boolean notEmpty( String string )
    {
        return StringUtils.hasText( string );
    }
}

