package com.suncode.dbexplorer.database;

import com.suncode.dbexplorer.database.internal.DatabaseConnectionTestResult;
import com.suncode.dbexplorer.util.authorization.AuthorizationHelper;
import com.suncode.dbexplorer.util.web.rest.RestController;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@Slf4j
@RequiredArgsConstructor( onConstructor_ = { @Autowired } )
public class ConnectionController
    extends RestController
{
    private final DatabaseFactory databaseFactory;

    private final AuthorizationHelper authorizationHelper;

    @RequestMapping( value = "connection/test", method = RequestMethod.POST )
    public ResponseEntity<ConnectionTestResult> testConnection( @RequestBody ConnectionString connectionString )
    {
        authorizationHelper.assertFullAdministrationRights( () -> {
        } );

        DatabaseConnectionTestResult result = databaseFactory.testConnection( connectionString );
        if ( result.getSuccess() )
        {
            return new ResponseEntity<>( HttpStatus.OK );
        }

        return new ResponseEntity<>( new ConnectionTestResult( result.getException().getMessage() ),
                                     HttpStatus.INTERNAL_SERVER_ERROR );
    }
}

@Getter
@Setter
@AllArgsConstructor
class ConnectionTestResult
{
    private String error;
}
