package com.suncode.dbexplorer.configurationtransfer.dto.alias.tableset.permissions;

import com.suncode.dbexplorer.alias.TablesSet;
import com.suncode.dbexplorer.alias.permission.AccessResource;
import com.suncode.dbexplorer.alias.permission.TablesSetPermission;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Component
public class ConfigurationTablesSetPermissionConverter
{
    public List<ConfigurationTablesSetPermissionDto> convertToDto( Set<TablesSetPermission> permissions )
    {
        return permissions.stream()
            .map( this::convertToDto )
            .collect( Collectors.toList() );
    }

    private ConfigurationTablesSetPermissionDto convertToDto( TablesSetPermission permission )
    {
        String resource;
        if ( permission.getResource().getType() == AccessResource.ResourceType.USER )
        {
            resource = permission.getResource().getUser().getUserName();
        }
        else
        {
            resource = permission.getResource().getGroup().getName();
        }

        return new ConfigurationTablesSetPermissionDto( permission.getLevel(),
                                                        resource,
                                                        permission.getResource().getType() );
    }

    public TablesSetPermission convertToEntity( ConfigurationTablesSetPermissionDto permissionDto, TablesSet tablesSet,
                                                AccessResource accessResource )
    {
        return new TablesSetPermission( tablesSet,
                                        permissionDto.getLevel(),
                                        accessResource );
    }
}
