package com.suncode.dbexplorer.configurationtransfer.dto.alias.settings;

import com.suncode.dbexplorer.alias.settings.ColumnSettings;
import com.suncode.dbexplorer.alias.settings.TableSettings;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Component
@RequiredArgsConstructor( onConstructor_ = { @Autowired } )
public class ConfigurationTableSettingConverter
{
    private final ConfigurationColumnSettingsConverter configurationColumnSettingsConverter;

    public List<ConfigurationTableSettingDto> convertToDto( Map<String, TableSettings> tableSettings )
    {
        List<ConfigurationTableSettingDto> tableSettingsDtos = new ArrayList<>();

        tableSettings.values()
            .forEach( tableSetting -> tableSettingsDtos.add( convertToDto( tableSetting ) ) );

        return tableSettingsDtos;
    }

    private ConfigurationTableSettingDto convertToDto( TableSettings tableSetting )
    {
        List<ConfigurationColumnSettingDto> columnsSettings = configurationColumnSettingsConverter.convertToDto( tableSetting.getColumnsSettings() );

        return new ConfigurationTableSettingDto( tableSetting.getSchemaName(),
                                                 tableSetting.getTableName(),
                                                 tableSetting.getDisplayName(),
                                                 columnsSettings );
    }

    public TableSettings convertToEntity( ConfigurationTableSettingDto tableSettingDto )
    {
        TableSettings tableSettings = new TableSettings( tableSettingDto.getSchemaName(), tableSettingDto.getTableName() );

        if ( StringUtils.isNotBlank( tableSettingDto.getDisplayName() ) )
        {
            tableSettings.setDisplayName( tableSettingDto.getDisplayName() );
        }

        for ( ConfigurationColumnSettingDto columnSettingDto : tableSettingDto.getColumnsSettings().getList() )
        {
            ColumnSettings columnSettings = configurationColumnSettingsConverter.convertToEntity( columnSettingDto );
            tableSettings.addColumnSettings( columnSettings );
        }
        return tableSettings;
    }
}
