package com.suncode.dbexplorer.configurationtransfer.dto.alias;

import com.suncode.dbexplorer.configurationtransfer.dto.alias.settings.ConfigurationTableSettingsContainer;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.tableset.ConfigurationTablesSetsContainer;
import com.suncode.pwfl.configuration.dto.ConfigurationDtoConfigObject;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Getter
@Setter
@NoArgsConstructor
public class ConfigurationAliasDto
    extends ConfigurationDtoConfigObject
{
    private String name;

    private ConfigurationConnectionStringDomainDto connectionString;

    private final ConfigurationTablesSetsContainer tableSets = new ConfigurationTablesSetsContainer();

    private final ConfigurationTableSettingsContainer settings = new ConfigurationTableSettingsContainer();

    private boolean isActive;

    private boolean logging;

    private boolean isSystemAlias;

    public ConfigurationAliasDto( String displayValue,
                                  String name,
                                  ConfigurationConnectionStringDomainDto connectionString,
                                  boolean isActive,
                                  boolean logging,
                                  boolean isSystemAlias )
    {
        super( displayValue );
        this.name = name;
        this.connectionString = connectionString;
        this.isActive = isActive;
        this.logging = logging;
        this.isSystemAlias = isSystemAlias;
    }
}
