package com.suncode.dbexplorer.configurationtransfer.dto;

import com.suncode.dbexplorer.configurationtransfer.dto.alias.ConfigurationAliasDto;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.ConfigurationAliasesContainer;
import com.suncode.pwfl.configuration.dto.plugins.PluginConfigurationDtoRoot;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class ConfigurationDbExplorerRootDto
    extends PluginConfigurationDtoRoot
{
    private final ConfigurationAliasesContainer aliases = new ConfigurationAliasesContainer();

    public ConfigurationDbExplorerRootDto( String pluginKey, String pluginName, List<ConfigurationAliasDto> aliasesList )
    {
        super( pluginKey, pluginName );
        this.aliases.getList().addAll( aliasesList );
    }
}