package com.suncode.dbexplorer.alias.permission.internal;

import java.util.List;

import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.suncode.dbexplorer.alias.TablesSet;
import com.suncode.dbexplorer.alias.permission.AccessResource;
import com.suncode.dbexplorer.alias.permission.AccessResource.ResourceType;
import com.suncode.dbexplorer.alias.permission.TablesSetPermission;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.support.HibernateEditableDao;

@Repository
public class TablesSetPermissionRepository
    extends HibernateEditableDao<TablesSetPermission, Long>
{

    public TablesSetPermission getResourcePermission( TablesSet set, AccessResource resource )
    {
        DetachedCriteria criteria = DetachedCriteria.forClass( TablesSetPermission.class )
            .add( Restrictions.eq( "tablesSet", set ) )
            .add( Restrictions.eq( "resource", resource ) );
        return findOne( criteria );
    }

    public List<TablesSetPermission> getPermissionsForUser( User user )
    {
        Disjunction permissions = Restrictions.or();
        DetachedCriteria criteria = DetachedCriteria.forClass( type )
            .add( permissions );

        // User
        Criterion userPermissions = Restrictions.and()
            .add( Restrictions.eq( "resource.type", ResourceType.USER ) )
            .add( Restrictions.eq( "resource.id", user.getObjectId() ) );

        permissions.add( userPermissions );

        // Group
        if ( !user.getGroups().isEmpty() )
        {
            Criterion groupPermissions = Restrictions.and()
                .add( Restrictions.eq( "resource.type", ResourceType.GROUP ) )
                .add( Restrictions.in( "resource.id", getGroupIds( user ) ) );

            permissions.add( groupPermissions );
        }

        return findByCriteria( criteria );
    }

    private List<Long> getGroupIds( User user )
    {
        List<Long> ids = Lists.newArrayList();
        for ( UserGroup group : user.getGroups() )
        {
            ids.add( group.getObjectId() );
        }
        return ids;
    }
}
