package com.suncode.dbexplorer.alias.permission.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.springframework.util.StringUtils;

import com.suncode.dbexplorer.alias.permission.AccessLevel;
import com.suncode.dbexplorer.alias.permission.AccessResource;
import com.suncode.dbexplorer.alias.permission.AccessResource.ResourceType;
import com.suncode.dbexplorer.alias.permission.TablesSetPermission;
import com.suncode.pwfl.administration.user.User;

public class TablesSetPermissionDto
{
    private Long id;

    private Long tablesSet;

    private Long resourceId;

    private String resourceName;

    private ResourceType resourceType;

    private AccessLevel accessLevel;

    public TablesSetPermissionDto()
    {
    }

    public TablesSetPermissionDto( TablesSetPermission permission )
    {
        this.id = permission.getId();
        this.tablesSet = permission.getTablesSet().getId();
        this.accessLevel = permission.getLevel();

        AccessResource resource = permission.getResource();
        this.resourceType = resource.getType();
        if ( resource.getType() == ResourceType.USER )
        {
            User user = resource.getUser();
            this.resourceId = user.getObjectId();
            this.resourceName =
                StringUtils.hasText( user.getFullName() ) ? String.format( "%s (%s)", user.getFullName(),
                                                                           user.getUserName() ) : user.getUserName();
        }
        else if ( resource.getType() == ResourceType.GROUP )
        {
            this.resourceId = resource.getGroup().getObjectId();
            this.resourceName = resource.getGroup().getName();
        }
    }

    public static List<TablesSetPermissionDto> from( Collection<TablesSetPermission> permissions )
    {
        List<TablesSetPermissionDto> dtos = new ArrayList<TablesSetPermissionDto>();
        for ( TablesSetPermission permission : permissions )
        {
            dtos.add( new TablesSetPermissionDto( permission ) );
        }
        return dtos;
    }

    public Long getId()
    {
        return id;
    }

    public void setId( Long id )
    {
        this.id = id;
    }

    public Long getTablesSet()
    {
        return tablesSet;
    }

    public void setTablesSet( Long tablesSet )
    {
        this.tablesSet = tablesSet;
    }

    public Long getResourceId()
    {
        return resourceId;
    }

    public void setResourceId( Long resourceId )
    {
        this.resourceId = resourceId;
    }

    public String getResourceName()
    {
        return resourceName;
    }

    public void setResourceName( String resourceName )
    {
        this.resourceName = resourceName;
    }

    public ResourceType getResourceType()
    {
        return resourceType;
    }

    public void setResourceType( ResourceType resourceType )
    {
        this.resourceType = resourceType;
    }

    public AccessLevel getAccessLevel()
    {
        return accessLevel;
    }

    public void setAccessLevel( AccessLevel accessLevel )
    {
        this.accessLevel = accessLevel;
    }
}
