package com.suncode.dbexplorer.alias.permission;

import java.util.Collections;
import java.util.Set;

import org.springframework.util.Assert;

import com.suncode.dbexplorer.alias.TablesSet;
import com.suncode.dbexplorer.alias.dto.SimpleTableDto;

public class SecuredTablesSet
{
    private final TablesSet set;

    private final AccessLevel accessLevel;

    public SecuredTablesSet( TablesSet set, AccessLevel accessLevel )
    {
        Assert.notNull( set, "[Assertion failed] - this argument is required; it must not be null" );
        Assert.notNull( accessLevel, "[Assertion failed] - this argument is required; it must not be null" );

        this.set = set;
        this.accessLevel = accessLevel;
    }

    public Long getId()
    {
        return set.getId();
    }

    public String getName()
    {
        return set.getName();
    }

    public AccessLevel getAccessLevel()
    {
        return accessLevel;
    }

    public Set<SimpleTableDto> getTables()
    {
        return Collections.unmodifiableSet( set.getTables() );
    }

    public TablesSet getSet()
    {
        return set;
    }
}
