package com.suncode.dbexplorer.alias.permission;

import com.suncode.dbexplorer.alias.permission.AccessResource.ResourceType;

import java.util.List;

public interface PermissionsService
{
    AccessResource getResource( Long id, ResourceType type );

    List<TablesSetPermission> getPermissions( Long setId );

    TablesSetPermission newPermission( Long setId, AccessResource resource, AccessLevel accessLevel );

    TablesSetPermission changePermissionLevel( Long permissionId, AccessLevel newLevel );

    TablesSetPermission deletePermission( Long permissionId );

    List<SecuredTablesSet> getSecuredTablesSets( String username );

    boolean hasAnyPermissions();

    boolean hasPermissionToTable( String username, String tableName, AccessLevel accessLevel );
}
