package com.suncode.dbexplorer.alias.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Lists;
import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.TablesSet;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;
import java.util.stream.Collectors;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties( ignoreUnknown = true )
public class TablesSetDto
{
    private Long id;

    private Long aliasId;

    private String name;

    private List<SimpleTableDto> tables = Lists.newArrayList();

    public TablesSetDto( Alias alias, TablesSet set )
    {
        this.id = set.getId();
        this.aliasId = alias.getId();
        this.name = set.getName();
        this.tables.addAll( set.getTables() );
    }

    public static List<TablesSetDto> from( Alias alias )
    {
        return alias.getTablesSets().stream()
                        .map( set -> new TablesSetDto( alias, set ) )
                        .collect( Collectors.toList() );
    }
}
