package com.suncode.dbexplorer.alias.dto;

import com.google.common.collect.Lists;
import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.Column;
import com.suncode.dbexplorer.alias.Table;
import lombok.Getter;
import lombok.Setter;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Setter
@Getter
public class TableDto
{
    private Long aliasId;

    private String schema;

    private String name;

    private boolean view;

    private String displayName;

    private Boolean logging;

    private PrimaryKeyDto primaryKey;

    private List<ColumnDto> columns = Lists.newArrayList();

    public TableDto()
    {
    }

    public TableDto( Alias alias, Table table )
    {
        this.aliasId = alias.getId();
        this.schema = table.getTableSchema().getSchema();
        this.name = table.getName();
        this.view = table.isView();
        this.displayName = table.getDisplayName();
        this.logging = table.getLogging();

        if ( table.getTableSchema().hasPrimaryKey() )
        {
            this.primaryKey = new PrimaryKeyDto( table.getPrimaryKey() );
        }

        for ( Column column : table.getColumns() )
        {
            this.columns.add( new ColumnDto( alias, table, column ) );
        }
    }

    public static List<TableDto> from( Alias alias, Set<Table> tables )
    {
        List<TableDto> dtos = new ArrayList<>();
        for ( Table table : tables )
        {
            dtos.add( new TableDto( alias, table ) );
        }
        return dtos;
    }
}
