package com.suncode.dbexplorer.alias.dto;

import com.google.common.collect.Lists;
import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;
import java.util.Set;

@Getter
@Setter
@NoArgsConstructor
public class SchemaDto
{
    private Long aliasId;

    private String name;

    private List<TableDto> tables;

    private Boolean available;

    public SchemaDto( Alias alias, Schema schema )
    {
        this.aliasId = alias.getId();
        this.name = schema.getName();
        this.tables = TableDto.from( alias, schema.getTables() );
        this.available = true;
    }

    public static SchemaDto unavailable()
    {
        SchemaDto schema = new SchemaDto();
        schema.setAvailable( false );
        return schema;
    }

    public static List<SchemaDto> from( Alias alias, Set<Schema> schemas )
    {
        List<SchemaDto> dtos = Lists.newArrayList();

        for ( Schema schema : schemas )
        {
            dtos.add( new SchemaDto( alias, schema ) );
        }

        return dtos;
    }
}
