package com.suncode.dbexplorer.alias.data.util.importer.config;

import lombok.AllArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;

@Configuration
@AllArgsConstructor
public class ImportConfig
{
    private final List<ImportStrategy> importStrategies;

    @Bean
    public Map<ImportType, ImportStrategy> importByType()
    {
        Map<ImportType, ImportStrategy> importsByType = new EnumMap<>( ImportType.class );
        importStrategies.forEach( importStrategy -> importsByType.put( importStrategy.importMode(), importStrategy ) );
        return importsByType;
    }
}
