package com.suncode.dbexplorer.alias.data;

import java.util.Map;

import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.Record;
import com.suncode.dbexplorer.database.RecordId;

public class UpdateRecord
{
    private String schema;
    
    private String table;

    private Map<String, Object> primaryKey;

    private Map<String, Object> data;

    public UpdateRecord()
    {
    }
    
    public UpdateRecord( String schema, String table )
    {
        this.schema = schema;
        this.table = table;
    }

    public String getSchema()
    {
        return schema;
    }

    public void setSchema( String schema )
    {
        this.schema = schema;
    }

    public void setTable( String table )
    {
        this.table = table;
    }

    public String getTable()
    {
        return table;
    }

    public Map<String, Object> getPrimaryKey()
    {
        return primaryKey;
    }

    public void setPrimaryKey( Map<String, Object> primaryKey )
    {
        this.primaryKey = primaryKey;
    }

    public Map<String, Object> getData()
    {
        return data;
    }

    public void setData( Map<String, Object> data )
    {
        this.data = data;
    }

    public Record record( DatabaseSession session )
    {
        Record record = session.createRecord( schema, table );

        for ( String col : data.keySet() )
        {
            record.set( col, data.get( col ) );
        }

        if ( !primaryKey.isEmpty() )
        {
            record.setId( RecordId.composite( primaryKey ) );
        }
        return record;
    }
}