package com.suncode.dbexplorer.alias;

import org.springframework.util.Assert;

import com.suncode.dbexplorer.alias.settings.ColumnSettings;
import com.suncode.dbexplorer.database.schema.ColumnSchema;

public class Column
{
    private final ColumnSchema column;

    private final ColumnSettings settings;

    public Column( ColumnSchema column, ColumnSettings settings )
    {
        Assert.notNull( column, "[Assertion failed] - this argument is required; it must not be null" );
        Assert.notNull( settings, "[Assertion failed] - this argument is required; it must not be null" );
        Assert.state( column.getName().equals( settings.getColumnName() ), "[Assertion failed] - this state invariant must be true" );

        this.column = column;
        this.settings = settings;
    }

    public String getName()
    {
        return column.getName();
    }

    public String getDisplayName()
    {
        return settings.getDisplayName();
    }
    
    public ColumnSchema getColumnSchema()
    {
        return column;
    }
}
