/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.util.persistence;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.suncode.dbexplorer.util.persistence.Json;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;

public class JsonInterceptor
extends EmptyInterceptor {
    private final ObjectMapper mapper = new ObjectMapper();

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        return this.serialize(this.findJsonObjects(state));
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        return this.serialize(this.findJsonObjects(currentState));
    }

    public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        return this.deserialize(this.findJsonObjects(state));
    }

    private boolean serialize(List<Json<?>> jsons) {
        if (jsons.isEmpty()) {
            return false;
        }
        for (Json<?> json : jsons) {
            try {
                json.setSerialized(this.mapper.writeValueAsBytes(json));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    private boolean deserialize(List<Json<?>> jsons) {
        if (jsons.isEmpty()) {
            return false;
        }
        for (Json<?> json : jsons) {
            try {
                Json deserialized = (Json)this.mapper.readValue(json.getSerialized(), json.getClass());
                json.apply(deserialized);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    private List<Json<?>> findJsonObjects(Object[] props) {
        ArrayList jsons = Lists.newArrayList();
        for (Object prop : props) {
            if (!(prop instanceof Json)) continue;
            jsons.add((Json)prop);
        }
        return jsons;
    }
}

