/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.type;

import com.suncode.dbexplorer.database.type.BinaryDataType;
import com.suncode.dbexplorer.database.type.BooleanDataType;
import com.suncode.dbexplorer.database.type.DataType;
import com.suncode.dbexplorer.database.type.DateDataType;
import com.suncode.dbexplorer.database.type.DateTimeDataType;
import com.suncode.dbexplorer.database.type.FloatDataType;
import com.suncode.dbexplorer.database.type.IntegerDataType;
import com.suncode.dbexplorer.database.type.StringDataType;
import com.suncode.dbexplorer.database.type.TimeDataType;
import com.suncode.dbexplorer.database.type.UnknownDataType;

public enum BasicDataType {
    STRING(StringDataType.class),
    INTEGER(IntegerDataType.class),
    FLOAT(FloatDataType.class),
    DATETIME(DateTimeDataType.class),
    DATE(DateDataType.class),
    TIME(TimeDataType.class),
    BOOLEAN(BooleanDataType.class),
    BINARY(BinaryDataType.class),
    UNKNOWN(UnknownDataType.class);

    private Class<? extends DataType> typeClass;

    private BasicDataType(Class<? extends DataType> typeClass) {
        this.typeClass = typeClass;
    }

    public boolean is(DataType dataType) {
        return this.typeClass.equals(dataType.getClass());
    }

    public static boolean is(DataType dataType, BasicDataType basicDataType) {
        return basicDataType.typeClass.equals(dataType.getClass());
    }

    public static BasicDataType of(DataType dataType) {
        for (BasicDataType enumType : BasicDataType.values()) {
            if (!BasicDataType.is(dataType, enumType)) continue;
            return enumType;
        }
        return null;
    }
}

